/*--------------------------------------
	imain.c

	Mark & Marc,  5/31/93 12:51:50
	contains the gateway calls communicating with the shell
*/

#include "icon.h"

extern EventRecordPtr	fEventPtr;
extern word			fUserID;
extern long			remHelpID;

word				edResFileID, shResFileID, fdResFileID;
word				isInitCurs;
word				mod;
handle				toolIcn[6];
handle				cursor[6];


word REM_OPEN(fOpenRecPtr p)
{
word				retVal, retErr;
long				sizeH;
Handle				ctlH, resData;
privateDataHndl		privH;
privateDataPtr		privP;
GrafPortPtr			winP;

	if (p->resType != rIcon) {
		if (p->resType != rBundle) {
			if (p->resType != rCursor) {
				return resInvalidTypeOrID;
			}
		}
	}
	if (!p->resID || (p->fFlag & (F_OPENSILENT | F_OPENDATA))) {
		if (p->fFlag & F_OPENDATA)
			resData = p->Data;

		else {
			resData = loadEdResource(p->resType, 0x20L);
		}
         p->resID = sAddResource(p->resType, p->resID);

		if (p->fFlag & F_OPENSILENT)
			return 0;
	}

	privH = (privateDataHndl) NewHandle(PRIVATESIZE, fUserID, 0x0018, 0L);
	privP = *privH;

	if (p->resType == rBundle) {
		privP->winTempH = loadEdRes(0x00000FFFL, rWindParam1);
	}
	else {
		privP->winTempH = loadEdRes(0x000018001L, rWindParam1);
	}

	privP->resType = p->resType;
	privP->resData = loadRes(p->resID, p->resType);
	privP->resID = p->resID;
	winP = NewWindow2(0L, 0L, 0L, 0L, 1, privP->winTempH, rWindParam1);
	SetPort(winP);
	privP->winP = winP;
	setTitle(p->resType, p->resID, winP);
	SetFrameColor(p->wColorPtr, winP);
	sAddPrivateData(p->resType, p->resID, 0, winP, 0L, (Handle)privH, 0x0020);

	switch (p->resType) {
		case rIcon:
		case rCursor:
			mod = false;
			retErr = iconOpen(privP, winP);
			break;
		case rBundle:
			retErr = openBundle(privP, winP);
			ShowWindow(winP);
			break;
	}
	return  0;
}

word REM_CLOSE(fCloseRecPtr p)
{
word				retErr;
handle				txtData;
long				txtLength;
GrafPortPtr			winP;
privateDataHndl		privH;
privateDataPtr		privP;

	winP = (GrafPortPtr) p->windowPtr;
	privH = getPrivate(winP);
	privP = *privH;

	checkData(winP);

	CloseWindow(winP);

	releaseRes(p->resType, p->resID);

	unloadEdRes(privP->winTempH, rWindParam1);

	if (p->resType != rBundle) {
		DisposeHandle(privP->resData);
		DisposeHandle((Handle) privP->editH);
		DisposeHandle((Handle) privP->undoH);
		DisposeHandle((Handle) privP->imageCache);
		DisposeHandle((Handle) privP->maskCache);
		DisposeHandle((Handle) privH);
	}
	else {
		/* dispose of bundle handles */
	}
	InitCursor();
	return  0;
}

word REM_WRITE(fCloseRecPtr p)
{
handle				txtData;
long				txtLength;
GrafPortPtr			winP;
privateDataHndl		private;
word				retErr;

	winP = (GrafPortPtr) p->windowPtr;
	checkData(winP);
	return 0;
}

word REM_EVENT(fEventRecPtr p)
{
	if (p->resType != rBundle) {
		return iconEvent(p);
	}
	else {
		return bundleEvent(p);
	}
}

word REM_ACTIVATE(fActivateRecPtr p)
{
handle				txtData;
GrafPortPtr			oldP, winP;
long				txtLength;
privateDataHndl		privH;
privateDataPtr		privP;
RegionHndl			theRegion;

	winP = (GrafPortPtr) fEventPtr->wmTaskData;
	if (p->fFlag & F_ACTIVATE) {
		privH = getPrivate(winP);
		privP = *privH;
		privP->tool |= 0x8000;
		InitCursor();
		isInitCurs = -1;
		p->fFlag |= (F_UNDO + F_CLIP + F_CLEAR + F_MENUAPPLY);
	}
	else {
		checkData(winP);
		InitCursor();
		isInitCurs = 0;
	}
	return  0;
}

word REM_GETLINK(fLinkRecPtr p)
{
	return 0;		/*  The shell knows all about us...  */
}

word REM_VIDMODE(fVidModeRecPtr p)
{
GrafPortPtr				winP;
privateDataHndl			privH;

	if (p->resType == rIcon) {
		(pointer) winP = p->windowPtr;
		privH = getPrivate(winP);
		SetWindowSize(*privH);
	}
	SetFrameColor(p->wColorPtr, winP);
	return 0;
}

word REM_PRINT(fCloseRecPtr p)
{
	return 0;				/* no printing in this version */
}

word REM_STARTUP(fStartStopRecPtr p)
{
word    i;

	fUserID = p->edUserID;
	edResFileID = p->edResFileID;
	shResFileID = p->shResFileID;
	fdResFileID = p->fdResFileID;

	for (i = 0; i < 6; i++) {
		toolIcn[i] = loadEdRes((long)i + 1L, rIcon);
		cursor[i] = loadEdRes((long)i + 1L, rCursor);
	}
	return  0;
}

word REM_SHUTDOWN(fStartStopRecPtr p)
{
word    i;

	for (i = 0; i < 6; i++) {
		unloadEdRes(toolIcn[i + 1], rIcon);
		unloadEdRes(cursor[i + 1], rCursor);
	}
	DisposeAll(fUserID);
	return 0;
}
